import React, {HTMLAttributes} from 'react';
import {observer} from 'mobx-react';
import './MusicBtn.less';
import musicStore from "@/store/musicStore.ts";
import classNames from "classnames";

export interface IMusicBtnProps extends HTMLAttributes<HTMLDivElement> {
  enable?: string;
  disable?: string;
}

import musicClose from "@/assets/homePage/musicoff.png";
import musicOpen from "@/assets/homePage/musicon.png";

@observer
class MusicBtn extends React.Component<IMusicBtnProps> {

  componentDidMount() {
  }

  componentWillUnmount() {
  }

  /**
   * 音效加载/播放
   */
  toggleHandle = (e) => {
    const {onClick} = this.props;
    musicStore.mute = !musicStore.mute;
    onClick?.(e);
  }

  render() {
    const {
      children,
      className,
      style = {},
      enable = musicOpen,
      disable = musicClose,
    } = this.props;

    const {mute} = musicStore;

    const cls = classNames(`com-music-btn`, className);

    return <div
      className={cls}
      style={{
        ...style
      }}
      onClick={this.toggleHandle}>
      {
        mute
          ? <img src={disable}/>
          : <img src={enable}/>
      }
      {children}
    </div>;
  }
}

export default MusicBtn;
