'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './selectmodal.less';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/swiper-bundle.css';
import API from '@/api';
import { _throttle } from '@/utils/utils';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
// 定义 state 的类型
interface SelectModalState {
  provinceList: any[]; // 假设 provinceList 是数组类型，可按需调整
  cityList: any[];
  areaList: any[];
  provinceCode: number;
  cityCode: number;
  areaCode: number;
}

// 定义 props 的类型
interface SelectModalProps {
  doSelect?: (data: { province: string; city: string; area: string }) => void; // 可选的 doSelect 方法
}
// 定义 params 类型
interface GetParentCodeParams {
  parentCode?: string | null;
}
@observer
class Selectmodal extends React.Component<SelectModalProps, SelectModalState> {
  constructor(props) {
    super(props);
    this.state = {
      provinceList: [],
      cityList: [],
      areaList: [],
      provinceCode: 0,
      cityCode: 0,
      areaCode: 0,
    };
  }

  swiperRef;
  swiperRef2;

  // getParentCode
  async componentDidMount() {
    //获取省
    await this.getCodeList(null, "provinceList");
    //获取市
    const { provinceList, provinceCode } = this.state;
    await this.getCodeList(provinceList[provinceCode]?.adCode, "cityList");
    //获取区
    const { cityList, cityCode } = this.state;
    await this.getCodeList(cityList[cityCode]?.adCode, "areaList");

    //获取街道
    const { areaList, areaCode } = this.state;
    await this.getCodeList(areaList[areaCode]?.adCode, "streetList");
  }

  /**获取省市区接口 */
  async getCodeList(parentCode, type) {
    const params: GetParentCodeParams = {};
    if (parentCode) {
      params.parentCode = parentCode;
    }
    const { success, data } = await API.getParentCode(params);
    if (success) {
      this.setState({
        [type]: data,
      } as Pick<SelectModalState, typeof type>);
    }
  }

  /**
   * 省选择
   * @param {*} swiper
   */
  onProvinceSwiper = (swiper) => {
    if (swiper) {
      swiper.on("slideChange", (swiper) => {
        console.error("Slide changed!", swiper.activeIndex);

        this.setState(
          {
            provinceCode: swiper.activeIndex,
          },
          async () => {
            //获取市
            const { provinceList } = this.state;
            await this.getCodeList(provinceList[swiper.activeIndex]?.adCode, "cityList");
            //获取区
            const { cityList, cityCode } = this.state;
            await this.getCodeList(cityList[cityCode]?.adCode, "areaList");

          }
        );
        this.swiperRef?.slideTo(0);
        this.swiperRef2?.slideTo(0);
      });
    }
  };
  /**
   * 市选择
   */
  onCitySwiper = (swiper) => {
    console.error("Slide changed!", swiper.activeIndex);

    this.setState(
      {
        cityCode: swiper.activeIndex,
      },
      async () => {
        //获取区
        const { cityList } = this.state;
        await this.getCodeList(cityList[swiper.activeIndex]?.adCode, "areaList");
      }
    );
    this.swiperRef2?.slideTo(0);
  };
  /**
   * 区选择
   * @param {*} swiper
   */
  onAreaSwiper = (swiper) => {
    console.error("Slide changed!", swiper.activeIndex);
    this.setState(
      {
        areaCode: swiper.activeIndex,
      }
    );
  };



  /**
   * 确认选择
   */
  doSelect = _throttle(() => {
    const { provinceList, cityList, areaList, provinceCode, cityCode, areaCode, } = this.state;
    const province = provinceList[provinceCode]?.name;
    const city = cityList[cityCode]?.name;
    const area = areaList[areaCode]?.name;
    console.log(province + "" + city + "" + area + "");
    //确定展示到页面
    const { doSelect } = this.props;
    doSelect && doSelect({ province, city, area });
    ModalCtrl.closeModal();
  });

  onClose() {
    ModalCtrl.closeModal();
  }

  render() {
    const { provinceList, cityList, areaList } = this.state;
    return (
      <div className="selectmodal">
        <span className="bg"></span>
        <div className="confirmbtn" onClick={this.doSelect}></div>

        <div className="dateCont">
          <div className="dates">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={this.onProvinceSwiper}>
              {provinceList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <div className="hours">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={(swiper) => (this.swiperRef = swiper)}
              onSlideChange={(swiper) => this.onCitySwiper(swiper)}>
              {cityList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <div className="minutes">
            <Swiper
              slidesPerView={5}
              initialSlide={0}
              centeredSlides={true}
              direction="vertical"
              className="_date"
              onSwiper={(swiper) => (this.swiperRef2 = swiper)}
              onSlideChange={(swiper) => this.onAreaSwiper(swiper)}>
              {areaList?.map((item, index) => (
                <SwiperSlide className="dateItem" key={index}>
                  <div>{item?.name}</div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        </div>

        <span className="close" onClick={this.onClose}></span>
      </div>
    );
  }
}
export default Selectmodal;
