import { Assets, Container, Sprite, Text } from "pixi.js";
import { Ease, Tween } from "@/pages/GamePage/tween";
import gameStore from "@/store/gameStore.ts";
import { GameConfig } from "@/pages/GamePage/config/Config.ts";

export class ScoreBubble extends Container {

  constructor(score: number) {
    super();
    this.initUI(score);
  }

  initUI(score: number) {

    const lv = gameStore.gameInfo.level;
    const skin = GameConfig.levelCfg[lv].skin;

    const sp = this.addChild(new Sprite(Assets.get(`蛇/${skin}/圈.png`)));
    sp.anchor.set(0.5, 0.5);

    const text = this.addChild(new Text({
      text: `${score > 0 ? "+" : ""}${score}`,
      style: {
        fontSize: 22,
        fill: 0xebe7cc,
        align: "center",
      }
    }));
    text.anchor.set(0.5, 0.5);

    this.scale.set(0, 0);
    Tween.get(this.scale)
      .to({ x: 1, y: 1 }, 222, Ease.backOut)
      .wait(500)
      .call(() => {
        this.removeFromParent();
      });

  }

}
