export class CodeError {
  name = 'CodeError';
  code = '';
  message = '';
  stack: string;
  payload: any;

  constructor(input, message?) {
    if (typeof input === 'number' || typeof input === 'string') {
      this.code = input + '';
    } else if (typeof input === 'object') {
      if (input['code']) {
        this.code = input['code'];
      } else {
        if (input instanceof Error) {
          this.code = input['message'];
        } else {
          console.warn('input without code field:', JSON.stringify(input));
        }
      }

      if (input['message']) {
        this.message = input['message'];
      }
      if (input['payload']) {
        this.payload = input['payload'];
      }
    }

    if (message) {
      this.message = message;
    }

    this.stack = (new Error()).stack;

    if (!Error['captureStackTrace'])
      this.stack = (new Error()).stack;
    else
      Error['captureStackTrace'](this, this.constructor);
  }
}
