import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import { Button, Toast } from "@grace/ui";
import { _asyncThrottle, miniGoUrl } from "@/utils/utils.ts";
import store from "@/store/store.ts";
import { SvgaPlayer } from "@grace/svgaplayer";
import homeSvga from "../../../src/assets/svga/2输出首页氛围.svga";
import btnSvga from "../../../src/assets/svga/3输出按钮.svga";
import taskSvga from "../../../src/assets/svga/1底框.svga";
import gameStore from "@/store/gameStore.ts";
import MusicBtn from "@/core/components/MusicBtn/MusicBtn.tsx";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import PrizePanel from "@/panels/PrizePanel/PrizePanel.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import GamePage from "@/pages/GamePage/GamePage.tsx";
import musicStore from '@/store/musicStore';
import Drawpop from '@/components/drawpop/drawpop';
import Posterpop from '@/components/posterpop/posterpop';
import API from '@/api';
import Rankpage from '../rankpage/rankpage';
import Rulepop from '@/components/rulepop/rulepop';

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  componentDidMount() {
    store.updateIndex();
    store.queryTask()
  }

  /** 开始游戏按钮*/
  startGame = _asyncThrottle(async () => {

    // if (!store.judgeActTime()) return;
    // if (store.indexData.remainTimes == 0) {
    //   Toast.show("暂无游戏次数哦")
    //   return;
    // }
    // const suc = await gameStore.start();
    // if (!suc) return;

    PageCtrl.changePage(GamePage);
  })

  /** 奖品按钮*/
  clickPrize = _asyncThrottle(() => {
    if (!store.judgeActTime(true, false)) return;
    ModalCtrl.showModal(PrizePanel, {
      prizeVO: {},
    });
  })

  /** 规则按钮*/
  clickRule = () => {
    if (!store.judgeActTime(true, false)) return;
    ModalCtrl.showModal(Rulepop);
  }
  clickDraw = () => {
    if (!store.judgeActTime()) return;
    ModalCtrl.showModal(Drawpop, {});
  }
  clickShop = () => {
    if (!store.judgeActTime()) return;
    miniGoUrl(store.frontVariable.shopUrl)
  }
  doTask = _asyncThrottle((item: { code: string; }) => {
    if (!store.judgeActTime()) return;
    if (item.code == "invite") {
      // 分享
      ModalCtrl.showModal(Posterpop)
      return;
    } else if (item.code == "scan") {
      miniGoUrl(store.frontVariable.scanUrl)
      return;
    }
  })

  getTaskPrize = _asyncThrottle(async (item) => {
    if (!store.judgeActTime()) return;
    const { success, data } = await API.sendPrize({
      prizePendingCode: item.prizePendingCode,
      taskId: item.id,
      taskCode: item.code
    })
    if (success) {
      Toast.show("游戏次数+" + data.options[0].sendCount)
    }
  })

  clickRank = _asyncThrottle(() => {
    if (!store.judgeActTime()) return;
    PageCtrl.changePage(Rankpage);
  })

  render() {
    const { remainTimes, remainDrawTimes, rank } = store.indexData
    return <div className="homepage" ref={(el) => this.root = el}>
      <span className="bg"></span>
      <div className="infobox">
        <span className="infobg"></span>
        <div className="prizeingo">
          <span className="prizename">{rank?.prizeName}</span>
          <span className="prizerank">前50名可得</span>
          <span className="prizeimg">
            <img src={rank?.prizeImg}></img>
          </span>
        </div>
        <div className="rankinfo" onClick={this.clickRank}>
          <span className="rankarr"></span>
          <span className="ranklab">我的排名</span>
          <span className="ranknum">{rank?.rank == -1 ? "未上榜" : rank?.rank + "名"}</span>
        </div>
      </div>
      <span className="title"></span>
      <span className="prizebtn"></span>
      <span className="rulebtn" onClick={this.clickRule}></span>
      {/* <span className="musicon"></span>
      <span className="musicf"></span> */}
      <MusicBtn className={`${musicStore.mute ? 'musicf' : 'musicon'}`}></MusicBtn>
      <Button className="mainbtn" onClick={this.startGame}>
        <SvgaPlayer className='btnsvga' src={btnSvga}></SvgaPlayer>
        <span className="mianimg"></span>
        <span className="mainnum">剩余次数：{remainTimes || 0}</span>
      </Button>
      <Button className="shopbtn" onClick={this.clickShop}></Button>
      <Button className="drawbtn" onClick={this.clickDraw}>
        <span className="drawimg"></span>
        <div className="drawnum">
          <span className="drawnumbg"></span>
          <span className="drawnumlab">{remainDrawTimes || 0}</span>
        </div>
      </Button>
      <div className="tasklist">
        {
          store.taskList?.map((item: any, index) => {
            return (
              <div className="taskitem" key={"task" + index}>
                {/* <span className="taskbg"></span> */}
                <SvgaPlayer className='taskbg' src={taskSvga}></SvgaPlayer>
                {
                  item.taskStatus == 2 ? <span className="taskfinishbtn"></span>
                    : item.taskStatus == 1 ? <span className="taskgetbtn" onClick={() => this.getTaskPrize(item)}></span>
                      : item.code == "invite" ? <span className="taskinvitebtn" onClick={() => this.doTask(item)}></span>
                        : item.code == "scan" ? <span className="taskscanbtn" onClick={() => this.doTask(item)}></span>
                          : <span className="taskgetbtn">{item.taskStatus}</span>
                }
                <span className="tasktit">{item.title}({item.completedSize}/{item.intervalLimitSize})</span>
                <span className="tasksub">{item.subTitle}</span>
                <span className="taskicon">
                  <img src={item.icon}></img>
                </span>
              </div>
            )
          })
        }
      </div>
      <span className="tasktitle"></span>
      <span className="logo"></span>
      <SvgaPlayer className='homesvga' src={homeSvga}></SvgaPlayer>
    </div>;
  }
}

export default HomePage;
