import { Element } from "@/pages/GamePage/Components/Element/Element.ts";
import { Ele } from "@/pages/GamePage/config/Config.ts";
import { collisionSys } from "@/pages/GamePage/GamePage.tsx";
import { DEG_TO_RAD } from "pixi.js";

/**
 * 酵母菌
 */
export class Yeast extends Element {

  id: Ele = Ele.Yeast;

  initUI(): void {
  }

  initPhy(): void {
    this.body = collisionSys.createCircle(
      this.getGlobalPosition(),
      this.sp.height / 2,
      {
        userData: {
          ele: this
        }
      }
    );
    this.body.setAngle(this.angle * DEG_TO_RAD);
  }

  updatePhy(): void {
  }
}
