import { Element } from "@/pages/GamePage/Components/Element/Element.ts";
import { Ele } from "@/pages/GamePage/config/Config.ts";
import { collisionSys } from "@/pages/GamePage/GamePage.tsx";
import { SATVector } from "detect-collisions";
import { DEG_TO_RAD } from "pixi.js";

/**
 * 艾草
 */
export class Mugwort extends Element {

  id: Ele = Ele.Mugwort;

  initUI(): void {
  }

  initPhy(): void {
    const { width, height } = this.sp;
    this.body = collisionSys.createBox(
      this.getGlobalPosition(),
      width / 2.1,
      height / 2.1,
      {
        userData: {
          ele: this
        }
      }
    );
    this.body.setOffset(new SATVector(-width / 2.1 / 2, -height / 2.1 / 2));
    this.body.setAngle(this.angle * DEG_TO_RAD);
  }
  updatePhy(): void {
    const { width, height } = this.sp;
    this.body.setOffset(new SATVector(-width / 2.1 / 2, -height / 2.1 / 2));
  }
}
