'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './posterpop.less';

import QRCode from 'qrcode';
import html2canvas from 'html2canvas';
import API from '@/api';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
type PosterpopState = {
  codeImg: string;
  shareImg: string;
};
@observer
class Posterpop extends React.Component<{}, PosterpopState> {
  constructor(props) {
    super(props);
    this.state = {
      codeImg: '',
      shareImg: ''
    }
  }
  async componentDidMount() {
    const { success, data } = await API.getInviteCode();
    if (!success) { return }
    // alert('公众号免登还没拼上 要记得加上')
    //https%3A%2F%2F98570-activity.m.dexfu.cn%2Fprojectx%2Fp016124b9%2Findex.html%3FappID%3D98570
    // let url = location.origin + "/projectx/" + CFG.projectId + "/index.html?appID=" + CFG.appID +
    let url = CFG.loginUrl + "&inviteCode=" + data.inviteCode;//encodeURIComponent(url);
    console.info('分享链接', url);
    const qrcodeSrc = await QRCode.toDataURL(url);
    // console.info(qrcodeSrc);
    this.setState({ codeImg: qrcodeSrc });

  }
  closePop() {
    ModalCtrl.closeModal()
  }
  render() {
    return (
      <div className="posterpop modal_center md33">
        <div className='back' onClick={this.closePop}></div>
        <div className="poster" id='poster'>
          <span className="posteriimg"></span>
          {
            this.state.codeImg && <img className='qrcode' src={this.state.codeImg} onLoad={() => {
              // 开始截图
              html2canvas(document.querySelector(".poster"), { useCORS: true, scale: 5 }).then(canvas => {
                const base64 = canvas.toDataURL()
                this.setState({
                  shareImg: base64
                })
              })
            }}></img>
          }

        </div>
        <div className='tipsLab'>正在加载中...</div>
        {
          this.state.shareImg && <img className='show' src={this.state.shareImg}></img>
        }
        <span className="tips"></span>
      </div>
    );
  }
}
export default Posterpop;
