import { makeAutoObservable, } from 'mobx';
import API from '../api/index';
import { Toast } from "@grace/ui";
import { IWxShareInfo } from "@/built-in/share/weixin/weixin.ts";
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Ranknoprizepop from '@/components/ranknoprizepop/ranknoprizepop';
import Rankprizepop from '@/components/rankprizepop/rankprizepop';

class Store {

  constructor() {
    makeAutoObservable(this);
  }

  /** 前端开发配置 */
  frontVariable: {
    privacyTxt: string,
    prizeInfoAuthTxt: string,
    shareInfo: IWxShareInfo,
    shopUrl?: string,
    scanUrl?: string,
  } = {
      privacyTxt: "",
      prizeInfoAuthTxt: "",
      shareInfo: {
        title: "",
        desc: "",
        link: "",
        imgUrl: "",
      },
    };

  ruleInfo = '';

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  }

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }

  indexData: {
    remainTimes?: number,
    uid?: string,
    actEndTimestamp?: number,
    timeStamp?: number,
    actStartTimestamp?: number,
    remainDrawTimes?: number,
    newAssist?: number,
    rankPopInfo?: {
      sendPrize: boolean,
      prizeName: string,
      prizeImg: string,
      rank: number
    },
    rank?: {
      rank: number,
      prizeName: string,
      prizeImg: string,
    }
  } = {};

  async updateIndex() {
    const { success, data, timeStamp } = await API.index();
    if (!success) {
      return;
    }
    this.indexData = data;
    this.indexData.timeStamp = timeStamp;

    if (data.rankPopInfo) {
      if (data.rankPopInfo.sendPrize) {
        ModalCtrl.showModal(Rankprizepop, { ...data.rankPopInfo })
      } else {
        ModalCtrl.showModal(Ranknoprizepop, { ...data.rankPopInfo })
      }
    }
  }

  judgeActTime(brakeStart = true, brakeEnd = true) {
    if (brakeStart && this.indexData.timeStamp < this.indexData.actStartTimestamp) {
      Toast.show("活动未开始");
      return false
    } else if (brakeEnd && this.indexData.timeStamp > this.indexData.actEndTimestamp) {
      Toast.show("活动已结束");
      return false
    }
    return true;
  }
  taskList = [
    {
      desc: "11111",
      title: "进入活动",
      subTitle: "12313121",
      id: "sign",
      code: "sign",
      icon: "//yun.duiba.com.cn/polaris/avatar.4279aa28d2b0d5a224eb5babbf5462c371079697.png",
      intervalLimitSize: 1,
      prizePendingCode: "sign",
      completedSize: 0,
      taskStatus: 1
    },
    {
      desc: "11111",
      title: "邀请助力",
      subTitle: "12313121",
      id: "invite",
      code: "invite",
      icon: "//yun.duiba.com.cn/polaris/avatar.4279aa28d2b0d5a224eb5babbf5462c371079697.png",
      intervalLimitSize: 1,
      prizePendingCode: "invite",
      completedSize: 0,
      taskStatus: 0
    },
    {
      desc: "11111",
      title: "扫码",
      subTitle: "12313121",
      id: "scan",
      code: "scan",
      icon: "//yun.duiba.com.cn/polaris/avatar.4279aa28d2b0d5a224eb5babbf5462c371079697.png",
      intervalLimitSize: 1,
      prizePendingCode: "scan",
      completedSize: 0,
      taskStatus: 0
    }
  ];
  async queryTask() {
    // const { success, data } = await API.queryTasks();
    // if (success) {
    //   this.taskList = data.item;
    // }
  }

}

export default (new Store());
