'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './drawpop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import API from '@/api';
import { _asyncThrottle } from '@/utils/utils';
import Drawnoprizepop from '../drawnoprizepop/drawnoprizepop';
import Drawprizepop from '../drawprizepop/drawprizepop';
import drawSvga from "../../../src/assets/svga/8输出抽奖.svga";
import { SvgaPlayer } from '@grace/svgaplayer';
// 定义 Drawpop 组件的 state 类型
type DrawpopState = {
  remainDrawTimes: number;
  prizeInfo: any[]; // 若 prizeInfo 有明确类型，可替换 any[]
  showSvga: boolean;
};

@observer
class Drawpop extends React.Component<{}, DrawpopState> {
  constructor(props: {}) {
    super(props);
    this.state = {
      remainDrawTimes: 1,
      prizeInfo: [
        {
          prizeName: "谢谢参与",
          prizeImg: '//yun.duiba.com.cn/polaris/%E6%95%B0%E6%8D%AE%E5%86%B3%E7%AD%96%E5%B7%A5%E5%85%B7.531c2dae250ab379fd6216eb038e60bc12ab9dd6.png'
        },
        {
          prizeName: "谢谢参与",
          prizeImg: '//yun.duiba.com.cn/polaris/%E6%95%B0%E6%8D%AE%E5%86%B3%E7%AD%96%E5%B7%A5%E5%85%B7.531c2dae250ab379fd6216eb038e60bc12ab9dd6.png'
        },
        {
          prizeName: "谢谢参与",
          prizeImg: '//yun.duiba.com.cn/polaris/%E6%95%B0%E6%8D%AE%E5%86%B3%E7%AD%96%E5%B7%A5%E5%85%B7.531c2dae250ab379fd6216eb038e60bc12ab9dd6.png'
        }
      ],
      showSvga: false,
    };
  }
  async componentDidMount() {
    const { success, data } = await API.drawIndex();
    if (success && data) {
      // 假设 data 包含 remainDrawTimes 和 prizeInfo
      this.setState({
        remainDrawTimes: data.remainDrawTimes || 0,
        prizeInfo: data.prizeInfo || [],
      });
    }
  }
  closePop = () => {
    ModalCtrl.closeModal();
  };
  drawInfo;
  drawPrize = _asyncThrottle(async () => {
    const { success, data } = await API.doDraw();
    if (success && data) {
      this.drawInfo = data;
      this.setState({
        showSvga: true
      })
    }
  })
  render() {
    return (
      <div className="drawpop modal_center">
        <span className="bg"></span>
        <span className="boxs"></span>
        {
          this.state.showSvga && <SvgaPlayer className='svga' src={drawSvga} loop={1} onEnd={() => {
            ModalCtrl.closeModal();
            if (this.drawInfo.prizeType == "thanks") {
              ModalCtrl.showModal(Drawnoprizepop)
            } else {
              ModalCtrl.showModal(Drawprizepop, { ...this.drawInfo })
            }
          }}></SvgaPlayer>
        }
        <span className="title"></span>
        <Button className={"drawbtn" + (this.state.remainDrawTimes > 0 ? " btnBreath" : "")} onClick={this.drawPrize}>
          <span className="drawbg"></span>
          <span className="drawnum">剩余次数：{this.state.remainDrawTimes}</span>
        </Button>
        <div className="prizelist">
          {
            this.state.prizeInfo.map((item, index) => {
              return <div className="prizeitem" key={"prizei" + index}>
                <span className="itembg">
                  <img src={item.prizeImg}></img>
                </span>
                <span className="itemname">{item.prizeName}</span>
              </div>
            })
          }
        </div>
        <Button className="back" onClick={this.closePop}></Button>
      </div>
    );
  }
}
export default Drawpop;