import React from "react";
import {observer} from "mobx-react";
import "./FailPanel.less";
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export interface IFailPanelProps {
  score: number,
  rank: number,
  prizeName: string,
  reachTargetScore: boolean,
  drawChance: number,
}

@observer
class FailPanel extends React.Component<IFailPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickBtn = _asyncThrottle(async () => {

  });

  render() {

    const {score, rank} = this.props;

    return <div className="FailPanel">
      <div className="bg"/>
      <div className="rank">当前排名:NO.{rank}</div>
      <div className="score">{score}<span>分</span></div>
      <div className="tip">
        单局游戏分数达200<br/>
        即可获得<span>1次抽奖机会</span>
      </div>
      <Button className="btn" onClick={this.clickBtn}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default FailPanel;
