import React, { Component } from 'react'
import { observer } from "mobx-react";
import { createRoot } from "react-dom/client";
import store from "./store/store";

import "./core/checkwebp.ts";
import "./MD";
import './App.less'
import '@csstools/normalize.css';

import bgm from "@/assets/music/bgm.mp3";
import musicStore from "@/store/musicStore.ts";
import { initWx } from "@/built-in/share/weixin/weixin.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import { GetCurrSkinId, getCustomShareId, getUrlParam } from "@/utils/utils.ts";

import HomePage from "@/pages/HomePage/HomePage.tsx";
import MyPrize from "@/pages/MyPrize/MyPrize.tsx";
import GamePage from "@/pages/GamePage/GamePage.tsx";
import LoginPage from './pages/LoginPage/LoginPage.tsx';

@observer
class App extends Component {

  showDefaultPage = () => {
    const skinId = GetCurrSkinId() || getCustomShareId();
    const defaultPage = {
      myPrize: MyPrize, // TODO 举例子 新宿台奖品页
      index: HomePage,
      Did1NjA5MTE: LoginPage
    }[skinId] || HomePage;
    PageCtrl.changePage(defaultPage);
  }

  async componentDidMount() {
    let inviteCode = getUrlParam("inviteCode");
    let newUrl = location.href.split("&")[0]
    if(inviteCode){
      newUrl = newUrl +"&inviteCode="+inviteCode;
    }
    window.history.replaceState({}, '', newUrl);
    this.showDefaultPage();
    musicStore.playSound(bgm, true);
    await store.getFrontVariable();
    await initWx(store.frontVariable.shareInfo);
    if (getUrlParam('inviteCode')) {
      store.doAssist()
    }
  }

  componentWillUnmount() {
  }

  render() {
    return (
      <>
        <PageCtrl />
        <ModalCtrl />
      </>
    );
  }
}

const root = createRoot(document.getElementById('root')!);
root.render(
  <App />
);

