import { Element } from "@/pages/GamePage/Components/Element/Element.ts";
import { Ele } from "@/pages/GamePage/config/Config.ts";
import { collisionSys } from "@/pages/GamePage/GamePage.tsx";
import { SATVector } from "detect-collisions";
import { Assets, DEG_TO_RAD, PointData, Sprite } from "pixi.js";
import { Tween } from "@/pages/GamePage/tween";

/**
 * 雄黄
 */
export class Realgar extends Element {

  id: Ele = Ele.Realgar;
  dgTip: Sprite;

  initUI(): void {

    this.dgTip = this.addChild(new Sprite(Assets.get('元素/危险.png')));
    this.dgTip.angle = -this.angle;
    this.dgTip.anchor.set(0.5, 0.5);
    this.dgTip.x = 28;

    Tween.get(this.dgTip, {
      loop: true,
    }).to({ alpha: 0.2 }, 444)
      .to({ alpha: 1 }, 444);

  }

  initPhy(): void {
    const { width, height } = this.sp;
    this.body = collisionSys.createBox(
      this.getGlobalPosition(),
      width / 2.1,
      height / 2.6,
      {
        userData: {
          ele: this
        }
      }
    );
    this.body.setOffset(new SATVector(-width / 2.1 / 2, -height / 2.6 / 2));
    this.body.setAngle(this.sp.angle * DEG_TO_RAD);
  }

  updatePhy(): void {
    const { width, height } = this.sp;
    this.body.setOffset(new SATVector(-width / 2.1 / 2, -height / 2.6 / 2))
  }

  onDestroy() {
    Tween.removeTweens(this.dgTip);
  }

  beEaten(pos: PointData){
    this.dgTip.visible = false;
    super.beEaten(pos);
  }
}
