'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './drawpop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import API from '@/api';
import { _asyncThrottle } from '@/utils/utils';
import Drawnoprizepop from '../drawnoprizepop/drawnoprizepop';
import Drawprizepop from '../drawprizepop/drawprizepop';
import drawSvga from "../../../src/assets/svga/2输出选中.svga";
import bgSvga from "../../../src/assets/svga/1输出标题.svga";
import { SvgaPlayer } from '@grace/svgaplayer';
import store from '@/store/store';
// 定义 Drawpop 组件的 state 类型
type DrawpopState = {
  remainDrawTimes: number;
  prizeInfo: any[]; // 若 prizeInfo 有明确类型，可替换 any[]
  showSvga: boolean;
};

@observer
class Drawpop extends React.Component<{}, DrawpopState> {
  constructor(props: {}) {
    super(props);
    this.state = {
      remainDrawTimes: 0,
      prizeInfo: [],
      showSvga: false,
    };
  }
  async componentDidMount() {
    const { success, data } = await API.drawIndex();
    if (success && data) {
      // 假设 data 包含 remainDrawTimes 和 prizeInfo
      this.setState({
        remainDrawTimes: data.remainDrawTimes || 0,
        // prizeInfo: data.prizeInfo || [],
      });
    }
  }
  closePop = () => {
    ModalCtrl.closeModal();
  };
  drawInfo;
  drawPrize = _asyncThrottle(async () => {
    const { success, data } = await API.doDraw();
    if (success && data) {
      store.updateIndex();
      this.drawInfo = data;
      this.setState({
        showSvga: true
      })
      // ModalCtrl.closeModal();
      // if (this.drawInfo.prizeId == "thanks") {
      //   ModalCtrl.showModal(Drawnoprizepop)
      // } else {
      //   ModalCtrl.showModal(Drawprizepop, { ...this.drawInfo })
      // }
    }
  })
  render() {
    return (
      <div className="drawpop modal_center">
        {/* <span className="bg"></span> */}
        <SvgaPlayer className='bgsvga' src={bgSvga}></SvgaPlayer>
        {!this.state.showSvga && <span className="boxs"></span>}
        {
          this.state.showSvga && <SvgaPlayer className='svga' src={drawSvga} loop={1} onEnd={() => {
            ModalCtrl.closeModal();

            if (this.drawInfo.prizeId == "thanks") {
              ModalCtrl.showModal(Drawnoprizepop)
            } else {
              ModalCtrl.showModal(Drawprizepop, { ...this.drawInfo })
            }
          }}></SvgaPlayer>
        }
        {/* <span className="title"></span> */}
        <Button className={"drawbtn md25" + (this.state.remainDrawTimes > 0 ? " btnBreath" : "")} onClick={this.drawPrize}>
          <span className="drawbg"></span>
          <span className="drawnum">剩余次数：{this.state.remainDrawTimes}</span>
        </Button>
        {/* <div className="prizelist">
          {
            this.state.prizeInfo.map((item, index) => {
              return <div className="prizeitem" key={"prizei" + index}>
                <span className="itembg">
                  <img src={item.prizeImg}></img>
                </span>
                <span className="itemname">{item.prizeName}</span>
              </div>
            })
          }
        </div> */}
        <Button className="back md26" onClick={this.closePop}></Button>
      </div>
    );
  }
}
export default Drawpop;