'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rankpage.less';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { Button } from '@grace/ui';
import API from '@/api';
import { dealTime2 } from '@/utils/utils';
// 定义 RankInfo 类型
type RankInfo = {
  index: number;
  score: number;
  userName: string;
  meFlag: boolean;
};

// 定义 MyRank 类型
type MyRank = {
  index: number;
  score: number;
  userName: string;
};

// 定义 RankOption 类型
type RankOption = {
  ranking: number;
  name: string;
  image: string;
};

// 定义 Rankpage 组件的 state 类型
type RankpageState = {
  day: string;
  hour: string;
  min: string;
  sec: string;
  timeStamp: number;
  openTime: number;
  rankInfos: RankInfo[];
  myRank: MyRank;
  rankOptions: RankOption[];
};

@observer
class Rankpage extends React.Component<{}, RankpageState> {
  constructor(props) {
    super(props);
    this.state = {
      day: '00',
      hour: '00',
      min: '00',
      sec: '00',
      timeStamp: 0,
      openTime: 0,
      rankInfos: [],
      myRank: {
        index: 0,
        score: 0,
        userName: ''
      },
      rankOptions: [],
    }
  }
  back() {
    PageCtrl.backPage();
  }
  timeStamp: number = 1746688893175;
  async componentDidMount() {
    if (this.state.openTime > this.timeStamp) {
      clearTimeout(this.timeCtn)
      this.countdown()
    }
    this.flushRank()
  }
  async flushRank() {
    const { success, data, timeStamp } = await API.rankInfo();
    if (success) {
      this.timeStamp = timeStamp
      this.setState({
        timeStamp,
        openTime: data.openTime,
        rankInfos: data.rankInfos,
        myRank: data.myRank,
        rankOptions: data.rankOptions,
      })
      if (data.openTime > timeStamp) {
        clearTimeout(this.timeCtn)
        this.countdown()
      }
    }
  }
  timeCtn
  countdown() {
    console.log("!@@@@!@@", this.state.openTime - this.timeStamp)
    let res = dealTime2(this.state.openTime - this.timeStamp)
    console.info("!@@@@!@@", res)
    this.setState({
      day: String(res.day),
      hour: String(res.hour),
      min: String(res.minute),
      sec: String(res.second),
    })
    clearTimeout(this.timeCtn)
    this.timeCtn = setTimeout(() => {
      const { openTime } = this.state;
      if (openTime > this.timeStamp) {
        this.timeStamp += 1000
        this.countdown()
      } else {
        this.flushRank()
      }
    }, 1000)
  }
  componentWillUnmount(): void {
    clearTimeout(this.timeCtn)
  }
  render() {
    const { rankInfos, myRank, rankOptions, day, hour, min, sec } = this.state;
    return (
      <div className="rankpage modal_center">
        <span className="bg"></span>
        <div className="countdown">
          <span className="cdbg"></span>
          <span className="day">{day}</span>
          <span className="hour">{hour}</span>
          <span className="min">{min}</span>
          <span className="sec">{sec}</span>
        </div>
        <span className="ranktitle"></span>
        <div className="list" style={{ height: `${(689 - (1624 - document.body.clientHeight * 750 / document.body.clientWidth) / 2) / 100}rem` }}>
          {
            rankInfos.length != 0 && <div className="myinfo">
              <span className="myrank">{myRank.index == -1 ? '999+' : (myRank.index > 999 ? '999+' : myRank.index)}</span>
              <span className="myname">{myRank.userName}（我）</span>
              <span className="myscore">{myRank.score}</span>
              <span className="mybg"></span>
            </div>
          }
          {
            rankInfos.map((item, index) => {
              return (
                <div className="item" key={'rank' + index}>
                  <span className="itemrank">{item.index}</span>
                  <span className="itemname">{item.userName}</span>
                  <span className="itemscore">{item.score}</span>
                  <span className="itembg"></span>
                </div>
              )
            })
          }
        </div>
        {
          rankInfos.length == 0 && <span className='empty'>暂无数据哦</span>
        }
        <div className="prizeitem">
          <span className="prizebg"></span>
          <span className="prizelight"></span>
          <span className="prizeimg">
            <img src={rankOptions?.[0]?.image}></img>
          </span>
        </div>
        <span className="title"></span>
        <Button className="back" onClick={this.back}></Button>
      </div>
    );
  }
}
export default Rankpage;
