import React from 'react';
import { observer } from 'mobx-react';
import './LoginPage.less';
import { Button } from "@grace/ui";
import { dateFormatter } from "@/utils/utils.ts";
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import { isWechatMiniProgram } from '@/AppTools';
import WxOpenModule from '@/components/wxOpenModule/wxOpenModule';

@observer
class LoginPage extends React.Component<any, any> {

    state = {
        list: [],
    }

    componentDidMount() {
    }

    clickBack = () => {
        // PageCtrl.backPage();
        // @ts-ignore
        wx.miniProgram.navigateTo({ url: "/pages/interaction/adver/adver?scene=864471992693305409" });
    }

    render() {

        return <div className="LoginPage">
            <div className="LoginPageBg" />
            <Button className="LoginPageBack" onClick={this.clickBack}>去登陆
                {
                    !isWechatMiniProgram() && <WxOpenModule
                        id={"prizebtn"}
                        appid={'wxb3b1041867218f81'}
                        username={'gh_706a4c5cb211'}
                        envVersion={'release'}
                        path={'/pages/interaction/adver/adver?scene=864471992693305409'}></WxOpenModule>
                }
            </Button>

        </div>;
    }
}

export default LoginPage;
