

import CryptoJS from 'crypto-js';

const { mode, pad, enc, AES } = CryptoJS;

const getOptions = (iv: string) => {
  return {
    iv: enc.Utf8.parse(iv),
    mode: mode.CBC,
    padding: pad.ZeroPadding,
  };
}

/** 加密 */
export function AESEncrypt(str: string, key: string, iv: string) {

  const options = getOptions(iv);

  return AES.encrypt(str, enc.Utf8.parse(key), options).toString();
}

/** 解密 */
export function AESDecrypt(cipherText: string, key: string, iv: string) {

  const options = getOptions(iv);

  return AES.decrypt(cipherText, enc.Utf8.parse(key), options)
    .toString(enc.Utf8)
    .trim()
    .replace(//g, '')
    .replace(//g, '')
    .replace(/\v/g, '')
    .replace(/\x00/g, '');
}
