import { makeAutoObservable, } from 'mobx';
import API from '../api/index';
import { Toast } from "@grace/ui";
import { IWxShareInfo } from "@/built-in/share/weixin/weixin.ts";

class Store {

  constructor() {
    makeAutoObservable(this);
  }

  /** 前端开发配置 */
  frontVariable: {
    privacyTxt: string,
    prizeInfoAuthTxt: string,
    shareInfo: IWxShareInfo,
  } = {
    privacyTxt: "",
    prizeInfoAuthTxt: "",
    shareInfo: {
      title: "",
      desc: "",
      link: "",
      imgUrl: "",
    },
  };

  ruleInfo = '';

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  }

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }

  indexData: {
    remainTimes?: number,
    uid?: string,
    endTime?: number,
    timeStamp?: number,
    startTime?: number,
  } = {};

  async updateIndex() {
    const { success, data, timeStamp } = await API.index();
    if (!success) {
      return;
    }
    this.indexData = data;
    this.indexData.timeStamp = timeStamp;
  }

  judgeActTime(brakeStart = true, brakeEnd = true) {
    if (brakeStart && this.indexData.timeStamp < this.indexData.startTime) {
      Toast.show("活动未开始，敬请期待");
      return false
    } else if (brakeEnd && this.indexData.timeStamp > this.indexData.endTime) {
      Toast.show("活动已结束");
      return false
    }
    return true;
  }

}

export default (new Store());
