import React from "react";
import {observer} from "mobx-react";
import "./SucPanel.less";
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import Drawpop from "@/components/drawpop/drawpop";

export interface ISucPanelProps {
  score: number,
  rank: number,
  prizeName: string,
  reachTargetScore: boolean,
  drawChance: number,
}

@observer
class SucPanel extends React.Component<ISucPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
    PageCtrl.changePage(HomePage);
  };

  clickBtn = _asyncThrottle(async () => {
    ModalCtrl.closeModal();
    PageCtrl.changePage(HomePage);
    ModalCtrl.showModal(Drawpop)
  });

  render() {

    const {score, rank} = this.props;

    return <div className="SucPanel">
      <div className="bg"/>
      <div className="rank">当前排名:NO.{rank <= 0 ? "999+" : rank}</div>
      <div className="score">{score}<span>分</span></div>
      <div className="tip">恭喜获得抽奖机会<span>+1</span></div>
      <Button className="btn md23" onClick={this.clickBtn}/>
      <Button className="close md24" onClick={this.clickClose}/>
    </div>;
  }
}

export default SucPanel;
