import {Toast} from "@grace/ui";

// 需要过滤的错误码
export const filterCode = ["600002"];

export const errMessageMap = {
  1020: "活动未开始",
  1021: "活动已结束",
  1007: "活动太火爆了，奖品已抢完咯～",
  100001: "登录过期啦，请重新登录哦～",
};

/**
 * 统一错误处理
 * @param e
 */
export function errorHandler(error) {
  if ((error.code == 0 && error.message == "请稍后再试") || filterCode.indexOf(`${error.code}`) >= 0) return;
  switch (error.code) {
    default: {
      const msg = errMessageMap[error.code] || error.message || '网络异常，请稍后再试';
      Toast.show(msg);
      break;
    }
  }
}
