import { Container } from "pixi.js";
import { Tween } from "@/pages/GamePage/tween";
import { Weight } from "@/pages/GamePage/Weight.ts";
import { EleConfig, EleData, mapSize } from "@/pages/GamePage/config/Config.ts";

const foodWeight = new Weight<EleData>();
const negWeight = new Weight<EleData>();

function initWeight() {
  for (let eleConfigKey in EleConfig) {
    const { neg, weight } = EleConfig[eleConfigKey];
    if (neg) {
      negWeight.add(EleConfig[eleConfigKey], weight);
    } else {
      foodWeight.add(EleConfig[eleConfigKey], weight);
    }
  }
}

export class ElementMgr {
  private root: Container;

  footCtn: Container;
  negCtn: Container;

  constructor(root: Container) {
    this.root = root;

    this.footCtn = this.root.addChild(new Container());
    this.negCtn = this.root.addChild(new Container());

    initWeight();
  }

  start() {
    Tween.get(this, { loop: true })
      .wait(1500)
      .call(() => {
        this.flushFood();
      });

    Tween.get(this, { loop: true })
      .wait(2000)
      .call(() => {
        this.flushNeg();
      })
      .wait(1000);
  }

  stop() {

  }

  flushFood() {
    if (this.footCtn.children.length > 15) return;
    const eleData = foodWeight.get();
    const ele = new eleData.cls();
    ele.x = Math.random() * (mapSize.width - 100) + 50;
    ele.y = Math.random() * (mapSize.height - 100) + 50;
    this.footCtn.addChild(ele);
    ele.init();
  }

  flushNeg() {
    if (this.negCtn.children.length > 4) return;
    const eleData = negWeight.get();
    const ele = new eleData.cls();
    ele.x = Math.random() * (mapSize.width - 100) + 50;
    ele.y = Math.random() * (mapSize.height - 100) + 50;
    this.negCtn.addChild(ele);
    ele.init();
  }
}
