import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import { Button } from "@grace/ui";
import { _asyncThrottle, miniGoUrl } from "@/utils/utils.ts";
import store from "@/store/store.ts";
import { SvgaPlayer } from "@grace/svgaplayer";
import homeSvga from "@/assets/svga/1输出首页氛围.svga";
import gameStore from "@/store/gameStore.ts";
import MusicBtn from "@/core/components/MusicBtn/MusicBtn.tsx";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import PrizePanel from "@/panels/PrizePanel/PrizePanel.tsx";
import RulePanel from "@/panels/RulePanel/RulePanel.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import GamePage from "@/pages/GamePage/GamePage.tsx";
import musicStore from '@/store/musicStore';
import Drawpop from '@/components/drawpop/drawpop';

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  componentDidMount() {
    store.updateIndex();
  }

  /** 开始游戏按钮*/
  startGame = _asyncThrottle(async () => {

    if (!store.judgeActTime()) return;

    const suc = await gameStore.start();
    if (!suc) return;

    PageCtrl.changePage(GamePage);
  })

  /** 奖品按钮*/
  clickPrize = _asyncThrottle(() => {
    ModalCtrl.showModal(PrizePanel, {
      prizeVO: {},
    });
  })

  /** 规则按钮*/
  clickRule = () => {
    ModalCtrl.showModal(RulePanel);
  }
  clickDraw = () => {
    ModalCtrl.showModal(Drawpop, {});
  }
  clickShop = () => {
    miniGoUrl(store.frontVariable.shopUrl)
  }

  render() {
    const { remainTimes, remainDrawTimes, rank } = store.indexData
    return <div className="homepage" ref={(el) => this.root = el}>
      <span className="bg"></span>
      <div className="infobox">
        <span className="infobg"></span>
        <div className="prizeingo">
          <span className="prizename">{rank?.prizeName}</span>
          <span className="prizerank">前50名可得</span>
          <span className="prizeimg">
            <img src={rank?.prizeImg}></img>
          </span>
        </div>
        <div className="rankinfo">
          <span className="rankarr"></span>
          <span className="ranklab">我的排名</span>
          <span className="ranknum">{rank?.rank == -1 ? "未上榜" : rank?.rank + "名"}</span>
        </div>
      </div>
      <span className="title"></span>
      <span className="prizebtn"></span>
      <span className="rulebtn"></span>
      {/* <span className="musicon"></span>
      <span className="musicf"></span> */}
      <MusicBtn className={`${musicStore.mute ? 'musicf' : 'musicon'}`}></MusicBtn>
      <Button className="mainbtn" onClick={this.startGame}>
        <span className="mainimg"></span>
        <span className="mainnum">剩余次数：{remainTimes || 0}</span>
      </Button>
      <Button className="shopbtn" onClick={this.clickShop}></Button>
      <Button className="drawbtn" onClick={this.clickDraw}>
        <span className="drawimg"></span>
        <div className="drawnum">
          <span className="drawnumbg"></span>
          <span className="drawnumlab">{remainDrawTimes || 0}</span>
        </div>
      </Button>
      <div className="tasklist">
        <div className="taskitem">
          <span className="taskbg"></span>
          <span className="taskscanbtn"></span>
          <span className="taskinvitebtn"></span>
          <span className="taskgetbtn"></span>
          <span className="taskfinishbtn"></span>
          <span className="tasktit">每日登录</span>
          <span className="tasksub">游戏次数*1</span>
          <span className="taskicon"></span>
        </div>
        <span className="taskitem2"></span>
      </div>
      <span className="tasktitle"></span>
      <span className="ip"></span>
      <span className="leaves"></span>
      <span className="logo"></span>
    </div>;
  }
}

export default HomePage;
