"use strict";

import React, { forwardRef, ForwardedRef } from "react";
import { observer } from "mobx-react";
import "./wxOpenModule.less";

// 定义 props 的类型
interface WxOpenModuleProps {
  id: string;
  username: string;
  appid: string;
  path: string;
  envVersion?: string;
}

// 扩展 JSX 命名空间，添加 wx-open-launch-weapp 组件类型定义
declare global {
  namespace JSX {
    interface IntrinsicElements {
      "wx-open-launch-weapp": {
        id: string;
        username: string;
        path: string;
        appid: string;
        "env-version": string;
        style?: React.CSSProperties;
        children?: React.ReactNode;
        ref?: ForwardedRef<unknown>;
      };
    }
  }
}

const WxOpenModule = observer(
  forwardRef((props: WxOpenModuleProps, ref: ForwardedRef<unknown>) => {
    return (
      <div className="wxOpenModule">
        <wx-open-launch-weapp
          id={props.id}
          ref={ref}
          username={props.username}
          appid={props.appid}
          path={props.path}
          env-version={props.envVersion || "release"}
          style={{
            width: "100%",
            height: "100%",
            position: "absolute",
            top: "0",
            left: "0",
            display: "block",
            border: "none",
            background: "none",
            opacity: 0,
            overflow: "hidden",
          }}
        >
          <script type="text/wxtag-template">
            <button
              style={{
                width: "100%",
                height: "100px",
                color: "red",
                display: "block",
                border: "none",
                background: "none",
                opacity: 0,
              }}
            >
              拉起小程序
            </button>
          </script>
        </wx-open-launch-weapp>
      </div>
    );
  })
);

export default WxOpenModule;