import React from "react";
import { observer } from "mobx-react";
import "./BackPanel.less";
import { Button } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";

export interface IFailPanelProps {
  ok: () => void,
  cancel: () => void,
}

@observer
class BackPanel extends React.Component<IFailPanelProps> {

  componentDidMount() {
  }

  clickCancel = () => {
    const { cancel } = this.props;
    ModalCtrl.closeModal();
    cancel && cancel();
  };

  clickOk = _asyncThrottle(async () => {
    const { ok } = this.props;
    ModalCtrl.closeModal();
    ok && ok();
    PageCtrl.changePage(HomePage);
  });

  render() {
    return <div className="BackPanel">
      <div className="bg"/>
      <Button className="ok" onClick={this.clickOk}/>
      <Button className="cancel" onClick={this.clickCancel}/>
    </div>;
  }
}

export default BackPanel;
