import React from "react";
import { observer } from "mobx-react";
import "./WedExpPanel.less";
import { Button } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";

import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";

export interface IWedExpPanelProps {
  signCredits: number;
  extraCredits: number;
  boolLimit: boolean;
  multupleValue: number;
  url: string;
  taskId: string;
  newLuckCreditsNum: number;
}

@observer
class WedExpPanel extends React.Component<IWedExpPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickVideo = _asyncThrottle(async () => {
    const { signCredits, extraCredits, boolLimit, multupleValue, url, taskId, newLuckCreditsNum } = this.props;

    ModalCtrl.closeModal();
  });

  render() {

    const { signCredits, extraCredits, multupleValue } = this.props;

    return <div className="WedExpPanel modal_center">
      <SvgaPlayer className="bgEffect" src={bgEffectSvga}/>
      <div className="bg"/>

      <div className="tip">
        获得{signCredits}积分<br/>
        解锁周三限时奖励
      </div>
      {
        !!extraCredits
          ? <div className="vip">
            <div className="img"/>
            <div className="multuple">{multupleValue}x</div>
          </div>
          : <div className="normal">
            <div className="img"/>
            <div className="multuple">{multupleValue}x</div>
          </div>
      }

      <div className="taskBg"/>
      <div className="logo"/>
      <div className="txt">
        观看品牌视频15s<br/>
        积分膨胀至{(signCredits + extraCredits) * multupleValue}积分
      </div>

      <div className="com_banner"/>

      <Button className="btn" onClick={this.clickVideo}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default WedExpPanel;
