import {Assets} from "pixi.js";

const manifest = {
  bundles: [],
}

const prefix = "../../../assets/Game/";
const files = import.meta.glob(`../../../assets/Game/**/*`, {
  import: "default",
  eager: true,
});

const bundleCfg = {
  name: "Game",
  assets: []
}

for (const key in files) {
  bundleCfg.assets.push({
    alias: key.replace(prefix, ""),
    src: files[key] as string,
  });
}

manifest.bundles.push(bundleCfg);

let inited = false;

export async function initBundle(): Promise<void> {
  if (inited) return Promise.resolve();

  console.time("initBundle");
  await Assets.init({
    manifest: manifest,
    skipDetections: true,
    preferences: {
      preferWorkers: false,
    }
  });
  Assets.backgroundLoadBundle(["Game"]);
  console.timeEnd("initBundle");
  inited = true;
}
