import { AnimatedSprite, Assets, Container, PointData, Sprite, Ticker } from "pixi.js";
import 'pixi.js/math-extras';
import { prefixInteger } from "@/utils/utils.ts";

export class Game extends Container {

  constructor() {
    super();
    this.initUI();
  }

  fullAni: AnimatedSprite;
  dropAni: AnimatedSprite;

  initUI() {
    const bg = this.addChild(new Sprite(Assets.get("招财猫_底.png")));
    bg.position.set(168, 332);

    const fullTextures = new Array(300).fill(0).map((_, i) => {
      return Assets.get(`落金币/落金币_${prefixInteger(i, 5)}.png`);
    });

    const fullAni = this.fullAni = this.addChild(new AnimatedSprite(fullTextures));
    fullAni.scale.set(0.66, 0.66);
    fullAni.anchor.set(0.5);
    fullAni.position.set(375, 553);
    fullAni.loop = false;
    fullAni.play();

    const dropTextures = new Array(300).fill(0).map((_, i) => {
      return Assets.get(`撒金币/撒金币_${prefixInteger(i, 5)}.png`);
    });
    const dropAni = this.dropAni = this.addChild(new AnimatedSprite(dropTextures));
    dropAni.scale.set(0.66, 0.66);
    dropAni.anchor.set(0.5);
    dropAni.position.set(375, 339);
    dropAni.loop = true;
    dropAni.play();
    // this.dropAni.visible = false;


    const top = this.addChild(new Sprite(Assets.get("招财猫_叠.png")));
    top.position.set(168, 332);
    // top.alpha = 0.7;

    const smile = this.addChild(new Sprite(Assets.get("表情_微笑.png")));
    smile.anchor.set(0.5);
    smile.scale.set(0.66, 0.66);
    smile.position.set(378, 564);

    this.on("pointerdown", this.onPointerDown, this);
    this.on("pointerup", this.onPointerUp, this);
  }

  playTo(progress: number) {
    progress = Math.min(Math.max(progress, 0), 1);


  }

  onPointerDown(e: any) {
    console.log(e)
  }

  onPointerUp(e: any) {
    console.log(e)
  }

  onUpdate(time: Ticker) {
    const dt = time.deltaMS / 1000;
  }

  destroy() {
    super.destroy();
  }
}
