import React from 'react';
import { observer } from 'mobx-react';
import store from "@/store/store.ts";
import { Button } from "@grace/ui";

import styles from "./Sign.module.less";
import classNames from "classnames";
import API from "@/api";
import { _asyncThrottle } from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import WedExpPanel from "@/panels/WedExpPanel/WedExpPanel.tsx";
import SignSucPanel from "@/panels/SignSucPanel/SignSucPanel.tsx";


@observer
class Sign extends React.Component<any, any> {

  componentDidMount() {

  }

  clickSign = _asyncThrottle(async () => {
    const { todaySignFlag } = store.indexData;
    if (todaySignFlag) return;

    const { success, data } = await API.sign();
    store.updateIndex();
    if (!success) return;

    const { signCredits, extraCredits, boolLimit, multupleValue, url, taskId, newLuckCreditsNum } = data;

    if (boolLimit) {
      // 周三限时奖励
      ModalCtrl.showModal(WedExpPanel, data);
    } else {
      ModalCtrl.showModal(SignSucPanel, data);
    }

  });

  render() {
    const { signRecords, continueSignDays, todaySignFlag } = store.indexData;

    const signedCount = signRecords?.filter((item) => item.boolSign).length || 0;
    const signProgress = Math.max(signedCount - 1, 0);

    return <div className={styles.sign}>
      <div className={styles.title}>已连续签到<span>{continueSignDays}</span>天</div>
      <div className={styles.tip}>断签7天后积分将清零</div>

      <div className={styles.itemRoot}>

        {
          signRecords?.map((item, index) => {
            const { id, boolSign, creditsNum, day } = item;
            const creditCls = classNames(styles.credits, {
              [styles.creditsSigned]: boolSign,
            });
            const dayCls = classNames(styles.day, {
              [styles.daySigned]: boolSign,
            });
            return <div key={id} className={styles.item}>
              <div className={creditCls}>
                {!boolSign && <div className={styles.creditTxt}>最高<span>{creditsNum}</span></div>}
              </div>
              <div className={dayCls}>第{day}天</div>
            </div>
          })
        }
      </div>

      <div className={styles.progressBar}>
        <div
          className={styles.progressFill}
          style={{
            width: `${100 / 6 * signProgress}%`,
          }}
        />
      </div>

      <div className={styles.progressPoint}/>
      <div className={styles.progressPoint} style={{
        transform: `translateX(${signProgress * 0.99}rem)`,
      }}/>

      <Button className={styles.btn} onClick={this.clickSign}/>
    </div>;
  }
}

export default Sign;
