import React from 'react';
import { observer } from 'mobx-react';
import './Check.less';
import store from "@/store/store.ts";
import { Button } from '@grace/ui';
import API from '@/api';
import { _asyncThrottle } from '@/utils/utils';


@observer
class Check extends React.Component<any, any> {

  constructor(props) {
    super(props);
    this.state = {
      taskInfo: {},
    };
  }

  componentDidMount() {
    this.getTaskInfo();
  }

  getTaskInfo = async () => {
    const { success, data } = await API.getTaskList();
    if (success && data) {
      this.setState({
        taskInfo: data || {},
      });
    }
  };

  // 按钮
  handlegofnish = _asyncThrottle(() =>{
    //todo
  })

  render() {
    const { } = store.indexData

    const { item } = this.state?.taskInfo || {};

    return <div className="check">
      <div style={{ height: 0 }}>
        <div className="check-bg" />
      </div>
      <div className="check-color" />

      <div className="actTime">活动时间:2025.5.10-9.10</div>

      <div className="title-line"></div>
      <div className="check-title">累计打卡挑战90天</div>

      <div className="prize-name">xxx奖励</div>

      <div className="prize-img"></div>

      <div className="insist-bg"></div>
      <div className="insist-day">已坚持 <span className="special">2 3</span> 天</div>

      <div className="process-tip">挑战进度<span className='process1'>53%</span> 距离拿奖还差<span className='process2'>23天</span></div>

      <div className="task">
        <div className="task-bg">
          <div className="task-plan">打卡任务 ｜ 3/6</div>
          {Array.isArray(item) &&
            item.length > 0 &&
            item?.map((v, i) => {
              const { title, subTitle, icon, code, taskStatus, intervalLimitSize, completedSize, intervalType } = v || {};

              // 获取按钮状态
              const renderActionButton = (code, taskStatus) => {
                // 先根据 code 分类
                switch (code) {
                  // todo
                  default:
                    return <Button className="gofinish" onClick={this.handlegofnish}/>
                }
              };

              return (
                <div className="task-item" key={i}>
                  {/* <span className="item-bg"></span> */}
                  <img className="item-icon" src={icon} alt="" />
                  <div className="item-name">
                    <span className="item-title">{title}</span>
                    <span className="item-tip">{subTitle}</span>
                  </div>
                  {renderActionButton(code, taskStatus)}
                </div>
              );
            })}
        </div>
      </div>



      <div className="calendar">
      
      

      </div>

    </div>;
  }
}

export default Check;
