"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./renewmodule.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class Renewmodule extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      activeChoice: "credits", // 默认
    };
  }

  handleClick = (choice) => {
    this.setState({ activeChoice: choice });
  };

  handleUse = (activeChoice) => {

    if (activeChoice === "credits") {
      ModalCtrl.closeModal();
      // 执行积分续签逻辑 todo
    } else {
      ModalCtrl.closeModal();
      // 执行青果续签逻辑 todo
    }
  };

  render() {
    const { activeChoice } = this.state;
    // bg1、bg3 是红色背景 bg2、bg4是白色背景
    return (
      <div className="renewmodule modal_center">
        <span className="bg"></span>
        <span className="headline"></span>
        <Button className="use" onClick={() => this.handleUse(activeChoice)} />
        <div
          className="choice_credits"
          onClick={() => this.handleClick("credits")}
        >
          <span className={activeChoice === "credits" ? "bg1" : "bg2"}></span>
          <span className="tip1">消耗积分续签</span>
          <span className="credits">当前积分：999999999</span>
          <span className="consume_credits">
            消耗<span className="count1">20000</span>积分进行续签
          </span>
        </div>
        <div className="choice_qg" onClick={() => this.handleClick("qg")}>
          <span className={activeChoice === "qg" ? "bg3" : "bg4"}></span>
          <span className="tip2">消耗青果续签</span>
          <span className="qg">当前青果：999999999</span>
          <span className="consume_qg">
            消耗<span className="count2">1000</span>青果进行续签
          </span>
        </div>
        <span className="title2">
          4月20日 <span className="special">未打卡</span>
        </span>
        <span className="title1">已累计打卡x天</span>
      </div>
    );
  }
}
export default Renewmodule;
