import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import store from "@/store/store.ts";
import Check from "@/pages/HomePage/Check/Check.tsx";
import Sign from "@/pages/HomePage/Sign/Sign.tsx";
import { Button, Toast } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rule from '../RulePage/RulePage';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import Top from "@/pages/HomePage/Top/Top.tsx";

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  async componentDidMount() {
    await store.doAssist();
    store.updateIndex();
    store.getTaskInfo()
    store.getBaseIndex()
    if (store.frontVariable?.homeTip?.length > 0) {
      store.changeHomeTip()
    }
    // store.queryTask()
    // if (getUrlParam('inviteCode')) {
    //   store.doAssist()
    // }
  }

  clickPrize = () => {
    if (!store.checkLoginStatus()) return;
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    if (!store.checkLoginStatus()) return;
    PageCtrl.changePage(Rule);
  }

  clickCredits = () => {
    if (!store.checkLoginStatus()) return;
    wx.miniProgram.navigateTo({ url: "/packages/user/points?source=duiba" });
  }

  clickActPre = () => {
    if (!store.checkLoginStatus()) return;
    Toast.show("活动未开始");
  }

  clickActEnd = () => {
    if (!store.checkLoginStatus()) return;
    Toast.show("活动已结束");
  }

  componentWillUnmount(): void {
    clearTimeout(store.homeTipsCon)
  }
  render() {
    const { creditsNum, guideFlag, actStartTime, currentTime, actEndTime } = store.indexData
    return <>
      <div className="homepage" ref={(el) => this.root = el}>
        <div className="homeRoot">
          <Top />
          {
            store.frontVariable.homeTip?.length > 0 && <span className='tipPop'>
              <span className='tipsLab'>{store.frontVariable.homeTip[store.homeTipIndex]}</span>
            </span>
          }
          <Sign />
          <Check />
          
          <Button className="credits"
            onClick={this.clickCredits}>{creditsNum > 999999 ? "999999+" : creditsNum}</Button>
          {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

          {currentTime >= actEndTime && <div className="ActEndMask" onClick={this.clickActEnd} />}

          <Button className="rule" onClick={this.clickRule} />
          <Button className="prize" onClick={this.clickPrize} />

          {currentTime < actStartTime && <div className="ActPreMask" onClick={this.clickActPre} />}
        </div>

      </div>
      {/*{!guideFlag && <GuidePanel />}*/}
    </>;
  }
}

export default HomePage;
