import React from "react";
import { observer } from "mobx-react";
import styles from "./ReturnAwardPanel.module.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import classNames from "classnames";
import { SvgaPlayer } from "@grace/svgaplayer";
import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";


export interface IReturnAwardPanelProps {
  creditNum: number,
}

@observer
class ReturnAwardPanel extends React.Component<IReturnAwardPanelProps> {

  componentDidMount() {
  }

  close = () => {
    ModalCtrl.closeModal();
  };

  clickGet = () => {
    ModalCtrl.closeModal();
  };


  render() {

    const {creditNum} = this.props;

    return <div className={classNames(styles.ReturnAwardPanel, "modal_center")}>
      <SvgaPlayer className={styles.bgEffect} src={bgEffectSvga}/>
      <div className={styles.bg}/>
      <div className={styles.tip}>恭喜获得{creditNum}积分</div>
      <div className="com_banner"/>
      <Button className={classNames(styles.ok, "md14")} onClick={this.clickGet}/>
      <Button className={styles.close} onClick={this.close}/>
    </div>;
  }

}

export default ReturnAwardPanel;
