import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import { getUrlParam } from "@/utils/utils.ts";
import store from "@/store/store.ts";
import Check from "@/pages/HomePage/Check/Check.tsx";
import Sign from "@/pages/HomePage/Sign/Sign.tsx";
import { Button } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rule from '../RulePage/RulePage';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Assist_fail from '../../components/assist_fail/assist_fail';
import Assist_succeed from '../../components/assist_succeed/assist_succeed';
import Choice_challenge from '../../components/choice_challenge/choice_challenge';
import Finish_task from '../../components/finish_task/finish_task';
import Finish_challenge from '../../components/finish_challenge/finish_challenge';
import Consume_qg from '../../components/consume_qg/consume_qg';
import Consume_credits from '../../components/consume_credits/consume_credits';
import Renewmodule from '../../components/renewmodule/renewmodule';
import Fail_challenge from '../../components/fail_challenge/fail_challenge';
import SignSucPanel from "@/panels/SignSucPanel/SignSucPanel.tsx";
import WedExpPanel from "@/panels/WedExpPanel/WedExpPanel.tsx";
import SkyFullGoldPanel from "@/panels/SkyFullGoldPanel/SkyFullGoldPanel.tsx";
import Top from "@/pages/HomePage/Top/Top.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";


import API from "@/api";
import VideoPanel from "@/panels/VideoPanel/VideoPanel.tsx";
import ObtainPanel from "@/panels/ObtainPanel/ObtainPanel.tsx";
import NewcomerPanel from "@/panels/NewcomerPanel/NewcomerPanel.tsx";
import GuidePanel from "@/panels/GuidePanel/GuidePanel.tsx";

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  async componentDidMount () {
    await store.doAssist();
    store.updateIndex();
    store.getTaskInfo()
    store.getBaseIndex()
    // store.queryTask()
    // if (getUrlParam('inviteCode')) {
    //   store.doAssist()
    // }
  }

  clickPrize = () => {
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    PageCtrl.changePage(Rule);
  }

  clickCredits = () => {
    wx.miniProgram.navigateTo({ url: "/packages/user/points?source=duiba" });
  }

  render() {
    const { creditsNum, guideFlag } = store.indexData
    return <>
      <div className="homepage" ref={(el) => this.root = el}>
        <div className="homeRoot">
          <Top />
          <Sign />
          <Check />

          <Button className="credits"
                  onClick={this.clickCredits}>{creditsNum > 999999 ? "999999+" : creditsNum}</Button>
          {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

          <Button className="rule" onClick={this.clickRule} />
          <Button className="prize" onClick={this.clickPrize} />
        </div>

      </div>
      {/*{!guideFlag && <GuidePanel />}*/}
    </>;
  }
}

export default HomePage;
