import { Container, Ticker } from "pixi.js";

export interface IBase {
  onLoad: () => void,
  onDestroy: () => void,
  onUpdate: (time: Ticker) => void,
}

export class Base extends Container implements IBase {

  constructor() {
    super();
    setTimeout(() => {
      this.onLoad();
    }, 0);
  }

  onLoad() {

  }

  onDestroy() {

  }

  onUpdate(time: Ticker) {

  }

  destroy() {
    this.onDestroy();
    super.destroy({
      children: true,
      texture: false,
      textureSource: false,
    });
  }
}
