import { makeAutoObservable, } from 'mobx';
import API from '../api/index';
import { Toast } from "@grace/ui";
import { IWxShareInfo } from "@/built-in/share/weixin/weixin.ts";
import { getUrlParam } from '@/utils/utils';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Choice_challenge from '../../src/components/choice_challenge/choice_challenge';
import SkyFullGoldPanel from "@/panels/SkyFullGoldPanel/SkyFullGoldPanel.tsx";

class Store {

  constructor() {
    makeAutoObservable(this);
  }

  /** 前端开发配置 */
  frontVariable: {
    shareInfo: IWxShareInfo,
    ruleImg?: string,
  } = {
    shareInfo: {
      title: "",
      desc: "",
      link: "",
      imgUrl: "",
    },
  };

  ruleInfo = '';

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  }

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }

  indexData: {
    actStartTime?: number,
    actEndTime?: number,
    currentTime?: number,

    guideFlag?: boolean,
    currentStoreNum?: number,
    storeLimitNum?: number,
    continueSignDays?: number,
    todaySignFlag?: boolean,
    signRecords?: {
      id: string,
      day: number,
      creditsNum: number,
      boolSign: boolean,
    }[],

    overflowBubble?: {
      id: number,
      creditsNum: number,
      expireTime: number,
    },

    bubbleRecords?: {
      id: number,
      creditsNum: number,
      expireTime: number,
    }[],

    returnAwardCreditsNum?: number,

    downGoldVo?: {
      creditsNum: number,
      multipleValue: number,
      taskId: string,
      url: string,
    }

  } = {};

  async updateIndex() {
    const { success, data } = await API.index();
    if (!success) {
      return;
    }
    this.indexData = data;

    if (data.downGoldVo) {
      ModalCtrl.showModal(SkyFullGoldPanel, data.downGoldVo);
    }

  }

  judgeActTime(brakeStart = true, brakeEnd = true) {
    if (brakeStart && this.indexData.currentTime < this.indexData.actStartTime) {
      Toast.show("活动未开始");
      return false
    } else if (brakeEnd && this.indexData.currentTime > this.indexData.actEndTime) {
      Toast.show("活动已结束");
      return false
    }
    return true;
  }

  // 首页挑战信息
  taskInfo: {
    boolOpenChallenge?: boolean;
    challengeStartTime?: number;
    challengeEndTime?: number;
    choosedChallengeId?: string;
    hasChallengeDay?: number;
    boolNeedResign?: boolean;
    challengeConfigList?: Array<{
      challengeId: string;
      challengeTotalDay: number;
      prizeName: string;
      prizeImg: string;
      resignJf: number;
      resignQg: number;
    }>;
    taskInfoList?: Array<{
      code: string;
      icon: string;
      subTitle: string;
      title: string;
      completedSize: number;
      intervalLimitSize: number;
      intervalType: number;
    }>;
    boolNeedChallengeCompletePop?: boolean;
    latestChallengeSuccessTime?: number;
    boolNeedResignPop?: boolean;
  } = {};

  async getTaskInfo() {
    const { success, data } = await API.getChallengeIndex();
    if (success && data) {
      this.taskInfo = data
      if(!data.choosedChallengeId){
        ModalCtrl.showModal(Choice_challenge)
      }
    }
  };

  async doAssist() {
    let code = getUrlParam('inviteCode')
    const { success, data } = await API.doAssist({ inviteCode: code });
    if (success) {
      Toast.show("成功为好友助力，一起来参与活动吧～");
    }
    history.replaceState({}, '', location.href.replace(new RegExp(`[?&]inviteCode=[^&]*`), ''));
  }

}

export default (new Store());
