import React from "react";
import { observer } from "mobx-react";
import "./SkyFullGoldPanel.less";
import { Button } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";

import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";

export interface ISkyFullGoldPanelProps {
  creditsNum: number;
  multipleValue: number;
  taskId: string;
  url: string;
}

@observer
class SkyFullGoldPanel extends React.Component<ISkyFullGoldPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickVideo = _asyncThrottle(async () => {
    const { creditsNum, multipleValue, url, taskId } = this.props;

    ModalCtrl.closeModal();
  });

  render() {
    const { creditsNum, multipleValue } = this.props;

    return <div className="SkyFullGoldPanel modal_center">
      <SvgaPlayer className="bgEffect" src={bgEffectSvga}/>
      <div className="bg"/>

      <div className="tip">
        观看视频<br/>
        获得{creditsNum}积分
      </div>
      {/*<div className="vip">*/}
      {/*  <div className="img"/>*/}
      {/*</div>*/}
      <div className="normal">
        <div className="img"/>
      </div>

      <div className="taskBg"/>
      <div className="logo"/>
      <div className="txt">
        观看品牌视频15s<br/>
        积分膨胀至{creditsNum * multipleValue}
      </div>

      <div className="com_banner"/>

      <Button className="btn" onClick={this.clickVideo}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default SkyFullGoldPanel;
