"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./assist_fail.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

/** 网络异常默认展示 */
export const DEFAULT_NET_ERROR = '网络异常，请稍后再试';

const FAIL_TEXT = {
  // todo
  // 助力已达上限 同一用户每天只可助力1次
  100020: "无法为自己助力",
  // 活动已结束
  500322: "每日只能为同一好友助力一次哦",
};

@observer
class Assist_fail extends React.Component {
  constructor(props) {
    super(props);
  }

  handlesign = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { code, message } = this.props.popData || {}
    return (
      <div className="assist_fail modal_center">
        <span className="bg"></span>
        <span className="title"></span>
        <span className="tip" dangerouslySetInnerHTML={{ __html: FAIL_TEXT[code] || message || DEFAULT_NET_ERROR }}></span>
        <Button className="sign" onClick={this.handlesign} />
        <span className="ribbon"></span>
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Assist_fail;
