import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import { getUrlParam } from "@/utils/utils.ts";
import store from "@/store/store.ts";
import Check from "@/pages/HomePage/Check/Check.tsx";
import Sign from "@/pages/HomePage/Sign/Sign.tsx";
import { Button } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rule from '../RulePage/RulePage';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Assist_fail from '../../components/assist_fail/assist_fail';
import Assist_succeed from '../../components/assist_succeed/assist_succeed';
import Choice_challenge from '../../components/choice_challenge/choice_challenge';
import Finish_task from '../../components/finish_task/finish_task';
import Finish_challenge from '../../components/finish_challenge/finish_challenge';
import Consume_qg from '../../components/consume_qg/consume_qg';
import Consume_credits from '../../components/consume_credits/consume_credits';
import Renewmodule from '../../components/renewmodule/renewmodule';
import Fail_challenge from '../../components/fail_challenge/fail_challenge';
import SignSucPanel from "@/panels/SignSucPanel/SignSucPanel.tsx";
import WedExpPanel from "@/panels/WedExpPanel/WedExpPanel.tsx";
import SkyFullGoldPanel from "@/panels/SkyFullGoldPanel/SkyFullGoldPanel.tsx";
import Top from "@/pages/HomePage/Top/Top.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";


import lightSvga from "@/assets/svga/5光点飘散.svga";
import API from "@/api";


@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  componentDidMount() {
    store.updateIndex();
    // store.queryTask()
    // if (getUrlParam('inviteCode')) {
    //   store.doAssist()
    // }

    // ModalCtrl.showModal(Fail_challenge);
  }

  clickPrize = () => {
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    PageCtrl.changePage(Rule);
  }

  render() {
    const {  } = store.indexData
    return <div className="homepage" ref={(el) => this.root = el}>
      <div className="homeRoot">

        <Top/>

        <SvgaPlayer className="homeSvga" src={lightSvga}/>

        <Sign/>
        <Check/>

        <Button className="credits">1344691</Button>
        {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

        <Button className="rule" onClick={this.clickRule} />
        <Button className="prize" onClick={this.clickPrize} />

      </div>
    </div>;
  }
}

export default HomePage;
