import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import store from "@/store/store.ts";
import Check from "@/pages/HomePage/Check/Check.tsx";
import Sign from "@/pages/HomePage/Sign/Sign.tsx";
import { Button } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rule from '../RulePage/RulePage';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import Top from "@/pages/HomePage/Top/Top.tsx";

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  async componentDidMount () {
    await store.doAssist();
    store.updateIndex();
    store.getTaskInfo()
    store.getBaseIndex()
    // store.queryTask()
    // if (getUrlParam('inviteCode')) {
    //   store.doAssist()
    // }
  }

  clickPrize = () => {
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    PageCtrl.changePage(Rule);
  }

  clickCredits = () => {
    wx.miniProgram.navigateTo({ url: "/packages/user/points?source=duiba" });
  }

  render() {
    const { creditsNum, guideFlag } = store.indexData
    return <>
      <div className="homepage" ref={(el) => this.root = el}>
        <div className="homeRoot">
          <Top />
          <Sign />
          <Check />

          <Button className="credits"
                  onClick={this.clickCredits}>{creditsNum > 999999 ? "999999+" : creditsNum}</Button>
          {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

          <Button className="rule" onClick={this.clickRule} />
          <Button className="prize" onClick={this.clickPrize} />
        </div>

      </div>
      {/*{!guideFlag && <GuidePanel />}*/}
    </>;
  }
}

export default HomePage;
