import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  /** 签到 */
  doSign: {
    uri: 'checkin_1/doSign.do',
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  // 奖品记录
  records: "common/records.do",
  // 红包补领
  redpacket: "common/moneyReissue.do",

  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
  },
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",

  // 挑战-首页
  getChallengeIndex: "challenge/index.do",

  //挑战-基础首页
  getChallengeBaseIndex: "challenge/baseIndex.do",

  // 挑战-补签
  getChallengeResign: "challenge/resign.do",

  // 挑战-任务完成接口
  getChallenegeComplete: "challenge/taskComplete.do",

  //挑战-获取邀请码
  getChallengeInviteCode: "challenge/inviteCode.do",

  // 挑战-助力
  getChallengeAssist: "challenge/assist.do",

  // 挑战-选择挑战
  getChooseChallenge: "challenge/chooseChallenge.do",

  // 扣积分
  queryStatus: "credits/queryStatus.do",
  creditsCost: {
    uri: "credits/creditsCost.do",
    method: "post"
  },

  // 奖品
  queryOrder: "customActivity/kouweiwang/prize/queryOrderNo",

  index: "main/index.do",
  completeGuide: "main/completeGuide.do",
  sign: "main/sign.do",
  receiveBubble: "main/receiveBubble.do",
  startVideo: "main/startVideo.do",


})

// console.log('======', API)

export default API
