import React from 'react';
import { observer } from 'mobx-react';
import store from "@/store/store.ts";
import { Button } from "@grace/ui";

import styles from "./Sign.module.less";
import classNames from "classnames";
import { _asyncThrottle } from "@/utils/utils.ts";

@observer
class Sign extends React.Component<any, any> {

  componentDidMount() {

  }

  clickSign = _asyncThrottle(async () => {
    const { todaySignFlag } = store.indexData;
    if (todaySignFlag) return;

    await store.doSign();

  });

  render() {
    const { signRecords, continueSignDays, todaySignFlag, expireDays } = store.indexData;

    const signedCount = signRecords?.filter((item) => item.boolSign).length || 0;
    const signProgress = Math.max(signedCount - 1, 0);

    return <div className={styles.sign}>
      <div className={styles.title}>已连续签到<span>{continueSignDays}</span>天</div>
      <div className={styles.tip}>断签{expireDays}天后积分将清零</div>

      <div className={styles.itemRoot}>

        {
          signRecords?.map((item, index) => {
            const { id, boolSign, creditsNum, day } = item;
            const creditCls = classNames(styles.credits, {
              [styles.creditsSigned]: boolSign,
            });
            const dayCls = classNames(styles.day, {
              [styles.daySigned]: boolSign,
            });
            return <div key={id} className={styles.item}>
              <div className={creditCls}>
                {!boolSign && <div className={styles.creditTxt}>最高<span>{creditsNum}</span></div>}
              </div>

              {
                boolSign
                  ? <div className={dayCls}>已签</div>
                  : <div className={dayCls}>第{day}天</div>
              }
            </div>
          })
        }
      </div>

      <div className={styles.progressBar}>
        <div
          className={styles.progressFill}
          style={{
            width: `${100 / 6 * signProgress}%`,
          }}
        />
      </div>

      <div className={styles.progressPoint}/>
      <div className={styles.progressPoint} style={{
        transform: `translateX(${signProgress * 0.99}rem)`,
      }}/>

      <Button className={classNames(styles.btn, "md1", { [styles.btnSigned]: todaySignFlag })} onClick={this.clickSign}/>
    </div>;
  }
}

export default Sign;
