"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./finish_challenge.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { SvgaPlayer } from '@grace/svgaplayer';

import lightSvga from "../../assets/svga/2输出签到成功弹窗.svga";

@observer
class Finish_challenge extends React.Component {
  constructor(props) {
    super(props);
  }

  handleclose = () => {
    ModalCtrl.closeModal();
  };

  handlehappy = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { prizeName, prizeImg } = this.props;
    return (
      <div className="finish_challenge modal_center">
        <SvgaPlayer className="dongxiao" src={lightSvga}/>
        <span className="bg"></span>
        <span className="title"></span>
        <span className="tip">获得{prizeName}奖励</span>
        <Button className="close" onClick={this.handleclose} />
        <Button className="happy" onClick={this.handlehappy} />
        <img className="icon" src={prizeImg} />
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Finish_challenge;
