import * as fs from "node:fs";


export function findFiles(dir: string, regExp: RegExp) {
  let fileArr = [];
  if (fs.existsSync(dir)) {
    const files = fs.readdirSync(dir);
    files.forEach((file) => {
      const fpath = dir + '/' + file;
      const stat = fs.lstatSync(fpath);
      if (stat.isFile() && regExp.test(file)) {
        fileArr.push(fpath);
      } else if (stat.isDirectory()) {
        fileArr.push(...findFiles(fpath, regExp));
      }
    })
  }
  return fileArr;
}

