import React from 'react';
import { observer } from 'mobx-react';
import './MyPrize.less';
import { Button } from "@grace/ui";
import { dateFormatter } from "@/utils/utils.ts";
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";

@observer
class MyPrize extends React.Component<any, any> {

    state = {
        list: [],
    }

    componentDidMount() {
        this.initList();
    }

    async initList() {
        const { success, data } = await API.records({
            ignoreSp: true,
        });
        if (!success) return;
        this.setState({
            list: data,
        });
    }

    clickBack = () => {
        PageCtrl.backPage();
    }

    clickItem = (item) => {
        if (item.url) {
            location.href = item.url
        } else {
            location.href = `/aaw/projectx/takePrize?projectOrderNo=${item.id}`
        }
    }

    render() {

        const { list } = this.state;

        return <div className="MyPrize">
            <div className="MyPrizeBg" />
            <div className="MyPrizeTitle" />
            <div className="prizeList">
                {
                    list.length > 0 ? list.map((item, index) => {
                        return <div className="prizeItem" key={index}>
                            <img className="prizeImg" src={item.extra.icon} />
                            <div className="prizeName">{item.extra.name}</div>
                            <div className="getTime">{dateFormatter(item.gmtCreate, "yyyy.MM.dd")}</div>
                            <Button className="use" onClick={this.clickItem.bind(this, item)} />
                        </div>
                        // }) : <div className="nothing"/>
                        }) : null
                    }
            </div>

            <Button className="MyPrizeBack" onClick={this.clickBack} />
            <div className="ditu"></div>

        </div>;
    }
}

export default MyPrize;
