import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  /** 签到 */
  doSign: {
    uri: 'checkin_1/doSign.do',
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  records: "records.query",
  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
  },
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",

  /** 任务列表 */
  getTaskList: {
    uri: "task_1/queryTasks.do",
  },
  /** 完成任务 */
  taskDoCompleted: {
    withToken: true,
    method: "post",
    uri: "task_1/doCompleted.do",
  },
  /** 发奖 */
  sendPrize: {
    withToken: true,
    method: "post",
    uri: "task_1/sendPrize.do",
  },

  index: "main/index.do",
  completeGuide: "main/completeGuide.do",
  sign: "main/sign.do",
  receiveBubble: "main/receiveBubble.do",


})

// console.log('======', API)

export default API
