"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./renewmodule.less";
import { Button, Toast } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import API from "../../../src/api/index";
import store from "../../../src/store/store.ts";
import { pre_reduce_score } from "../../store/credits.js";
import Finish_resign from "../finish_resign/finish_resign.jsx";
import { handleLogExposure, handleLogClick } from "@/MD";
@observer
class Renewmodule extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      activeChoice: "credits", // 默认
    };
  }

  componentDidMount() {
    store.getBaseIndex();
  }

  handleclose = () => {
    ModalCtrl.closeModal();
  };

  handleClick = (choice) => {
    this.setState({ activeChoice: choice });
  };

  handleUse = async (activeChoice, inferQg, inferJf, resignJf) => {
    handleLogClick(18);
    if (activeChoice === "credits") {
      // 执行积分续签逻辑 todo
      if (!inferJf) return Toast.show("积分不足");
      await pre_reduce_score(
        {
          toPlaywayId: "challenge",
          toActionId: "resign",
          desc: "resign_credits_desc",
          credits: resignJf,
        },
        async () => {
          const { success } = await API.getChallengeResign({
            costType: 2,
            ticket: store.ticketNum,
          });
          if (success) {
            ModalCtrl.closeModal();
            ModalCtrl.showModal(Finish_resign);
          }
          store.getTaskInfo();
          store.getBaseIndex();
        }
      );
    } else {
      // 执行青果续签逻辑 todo
      if (!inferQg) return Toast.show("青果不足");
      const { success } = await API.getChallengeResign({ costType: 1 });
      if (success) {
        ModalCtrl.closeModal();
        ModalCtrl.showModal(Finish_resign);
      }
      store.getTaskInfo();
      store.getBaseIndex();
    }
  };

  render() {
    handleLogExposure(18);
    const { activeChoice } = this.state;
    const { hasChallengeDay, resignJf, resignQg } = this.props;
    const { jfNum, qgNum } = store?.baseInfo || {};

    // qg是否足够
    const inferQg = qgNum >= resignQg;
    // 积分是否足够
    const inferJf = jfNum >= resignJf;

    // bg1、bg3 是红色背景 bg2、bg4是白色背景
    return (
      <div className="renewmodule">
        <span className="bg"></span>
        <span className="headline"></span>
        <Button
          className="use"
          onClick={() =>
            this.handleUse(activeChoice, inferQg, inferJf, resignJf)
          }
        />
        <div
          className="choice_credits"
          onClick={() => this.handleClick("credits")}
        >
          <span className={activeChoice === "credits" ? "bg1" : "bg2"}></span>
          <span className="tip1">消耗积分续签</span>
          <span className="credits">当前积分：{jfNum}</span>
          <span className="consume_credits">
            消耗<span className="count1">{resignJf}</span>积分进行续签
          </span>
        </div>
        <div className="choice_qg" onClick={() => this.handleClick("qg")}>
          <span className={activeChoice === "qg" ? "bg3" : "bg4"}></span>
          <span className="tip2">消耗青果续签</span>
          <span className="qg">当前青果：{qgNum}</span>
          <span className="consume_qg">
            消耗<span className="count2">{resignQg}</span>青果进行续签
          </span>
        </div>
        <span className="title2">
          第{hasChallengeDay + 1}天 <span className="special">未打卡</span>
        </span>
        <span className="title1">已累计打卡{hasChallengeDay}天</span>
        <Button className="close" onClick={this.handleclose} />
      </div>
    );
  }
}
export default Renewmodule;
