import { AnimatedSprite, Assets, Container, PointData, Sprite, Ticker } from "pixi.js";
import 'pixi.js/math-extras';
import { prefixInteger } from "@/utils/utils.ts";
import { Base } from "@/pages/HomePage/Top/base/Base.ts";
import { observer, reactor } from "@/pages/HomePage/Top/mobx/decorators.ts";
import store from "@/store/store.ts";
import { GifSprite } from "pixi.js/gif";
import { BubbleMgr } from "@/pages/HomePage/Top/Components/BubbleMgr.ts";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/HomePage/Top/GameEvent.ts";

@observer
export class Game extends Base {

  fullAni: AnimatedSprite;
  dropAni: GifSprite;
  bubbleMgr: BubbleMgr;

  onLoad() {
    const bg = this.addChild(new Sprite(Assets.get("招财猫_底.png")));
    bg.position.set(168, 332);

    const fullTextures = new Array(300).fill(0).map((_, i) => {
      return Assets.get(`落金币/落金币_${prefixInteger(i, 5)}.png`);
    });

    const fullAni = this.fullAni = this.addChild(new AnimatedSprite(fullTextures));
    fullAni.scale.set(0.66);
    fullAni.anchor.set(0.5);
    fullAni.position.set(375, 553);
    fullAni.loop = false;
    // fullAni.play();

    const dropAni = this.dropAni = this.addChild(new GifSprite({ source: Assets.get("撒金币.gif") }));
    dropAni.anchor.set(0.5);
    dropAni.position.set(375, 339);
    dropAni.loop = true;
    dropAni.play();
    this.dropAni.visible = false;

    const top = this.addChild(new Sprite(Assets.get("招财猫_叠.png")));
    top.position.set(168, 332);
    // top.alpha = 0.7;

    const smile = this.addChild(new Sprite(Assets.get("表情_微笑.png")));
    smile.anchor.set(0.5);
    smile.scale.set(0.66);
    smile.position.set(378, 564);

    this.bubbleMgr = this.addChild(new BubbleMgr());

    globalEvent.on(GameEvent.ReceiveEffect, this.receiveEffect, this);
  }

  playTo(progress: number) {
    progress = Math.min(Math.max(progress, 0), 1);

    const nowFrame = this.fullAni.currentFrame;
    const targetFrame = Math.floor(this.fullAni.totalFrames * progress);

    const isPositive = nowFrame < targetFrame;
    this.fullAni.animationSpeed = isPositive ? 1 : -1;
    this.dropAni.visible = isPositive;

    this.fullAni.play();
    this.fullAni.onFrameChange = (currentFrame) => {
      if (currentFrame === targetFrame) {
        this.fullAni.animationSpeed = 1;
        this.fullAni.onFrameChange = null;
        this.dropAni.visible = false;
        this.fullAni.stop();
      }
    };
  }

  @reactor(() => store.indexData.currentStoreNum)
  onStoreNumChange(currentStoreNum: number) {
    this.playTo(currentStoreNum / store.indexData.storeLimitNum);
  }

  @reactor(() => store.indexData.storeLimitNum)
  onStoreLimitChange(storeLimitNum: number) {
    this.playTo(store.indexData.currentStoreNum / storeLimitNum);
  }

  receiveEffect(point: PointData) {
    for (let i = 0; i < 5; i++) {
      const sp = this.addChild(new Sprite(Assets.get("黄色气泡.png")));
      sp.anchor.set(0.5)
      sp.position.set(point.x, point.y);
      Tween.get(sp)
        .wait(i * 50)
        .to({ alpha: 0.7, scaleX: 0.5, scaleY: 0.5, x: 80, y: 110 }, 888, Ease.quadOut)
        .call(() => {
          sp.destroy();
        });
    }
  }

  onUpdate(time: Ticker) {
    // const dt = time.deltaMS / 1000;
  }

  onDestroy() {
    this.dropAni.removeFromParent();
  }
}
