import React from 'react';
import { observer } from 'mobx-react';
import './MyPrize.less';
import { Button, Toast } from "@grace/ui";
import { dateFormatter, miniGoUrl } from "@/utils/utils.ts";
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";

@observer
class MyPrize extends React.Component<any, any> {

    state = {
        list: [],
    }

    componentDidMount() {
        this.initList();
    }

    async initList() {
        const { success, data } = await API.records({
            ignoreSp: true,
        });
        if (!success) return;
        this.setState({
            list: data,
        });
    }

    clickBack = () => {
        PageCtrl.backPage();
    }

    clickItem = async (item) => {
        const { id, url } = item
        if (url) {
            location.href = url
        } else {
            if (item.extra.refType === 'virtual') {

                // 商家自冲奖品类型配置 {"prizeId":"奖品ID","type":"类型(1-专项特惠2-积分商城奖品3-积分奖品)"}
                // 注意：旧的奖品没有type字段 需兼容
                if (item?.extra.type == 1) {
                    return miniGoUrl(CFG.isNewMiniVersion ? "/packages/user/exclusiveOffer?source=duiba" : "/pagesNews/user/userRed")
                } else if (item?.extra.type == 3) {
                    return miniGoUrl('/packages/user/points?source=duiba')
                }
                const res = await API.queryOrder({
                    recordId: item.id,
                    projectId: CFG.projectId
                });
                if (res?.orderNo) {
                    // 线上正式用这个
                    wx.miniProgram.reLaunch({
                        url:
                            (CFG.isNewMiniVersion ? "/pages/index?source=duiba&orderNo=" : "/pages/index/index?orderNo=")
                            + id
                            + "&activityId=" + (res?.activityId) + "&uid=" + (res?.uid) + "&activityUrl=" + encodeURIComponent(location.origin + "/projectx/" + CFG.projectId + '/index.html?jumpFlag=1') + '&uid=' + res?.uid
                    })
                } else {
                    Toast.show('请稍后再试～')
                }
            } else {
                location.href = `/aaw/projectx/takePrize?projectOrderNo=${id}`
            }
        }
    }

    handleyifafang = (item) => {
        Toast.show("已发放")
    }

    handlebufa = async (item) => {
        const { success } = await API.redpacket({
            prizeRecordId: item.id,
        });
        if (success) {
            this.initList();
        }
    }

    handleshibai = (item) => {
        Toast.show("发放失败")
    }

    handlefafangzhong = (item) => {
        Toast.show("正在发放中，请耐心等待")
    }

    render() {

        const { list } = this.state;

        return <div className="MyPrize">
            <div className="MyPrizeBg" />
            <div className="MyPrizeTitle" />
            <div className="prizeList">
                {
                    list.length > 0 ? list.map((item, index) => {
                        return (
                            <div className="prizeItem" key={index}>
                                <img className="prizeImg" src={item.extra.icon} />
                                <div className="prizeName">{item.extra.name}</div>
                                <div className="getTime">{dateFormatter(item.gmtCreate, "yyyy.MM.dd")}</div>
                                {item.type === 4 ? (
                                    <>
                                        {item.moneyStatus === 1 && <Button className="yifafang" onClick={() => this.handleyifafang(item)} />}
                                        {item.moneyStatus === 2 && <Button className="shibai" onClick={() => this.handleshibai(item)} />}
                                        {item.moneyStatus === 10 && <Button className="bufa" onClick={() => this.handlebufa(item)} />}
                                        {item.moneyStatus === 11 && <Button className="fafangzhong" onClick={() => this.handlefafangzhong(item)} />}
                                    </>
                                ) : (
                                    <Button className="use" onClick={() => this.clickItem(item)} />
                                )}
                            </div>
                        )
                        // }) : <div className="nothing"/>
                    }) : null
                }
            </div>

            <Button className="MyPrizeBack" onClick={this.clickBack} />
            <div className="ditu"></div>

        </div>;
    }
}

export default MyPrize;
