"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./finish_challenge.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class Finish_challenge extends React.Component {
  constructor(props) {
    super(props);
  }

  handleclose = () => {
    ModalCtrl.closeModal();
  };

  handlehappy = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { prizeName, prizeImg } = this.props;
    return (
      <div className="finish_challenge modal_center">
        <span className="dongxiao"></span>
        <span className="bg"></span>
        <span className="title"></span>
        <span className="tip">获得{prizeName}奖励</span>
        <Button className="close" onClick={this.handleclose} />
        <Button className="happy" onClick={this.handlehappy} />
        <img className="icon" src={prizeImg} />
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Finish_challenge;
