import { Container, Ticker, DestroyOptions } from "pixi.js";

export interface IBase {
  onLoad: () => void,
  onDestroy: () => void,
  onUpdate: (time: Ticker) => void,
}

export class Base extends Container implements IBase {

  constructor() {
    super();
    setTimeout(() => {
      this.onLoad();
    }, 0);
  }

  onLoad() {

  }

  onDestroy() {

  }

  onUpdate(time: Ticker) {

  }

  destroy(options?: DestroyOptions) {
    this.onDestroy();
    super.destroy(options);
  }
}
